/*
 * File:     IMediaTypeInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IMediaTypeInfo
 */
public class IMediaTypeInfoImpl extends IDispatchImpl implements IMediaTypeInfo {
    public static final String INTERFACE_IDENTIFIER = IMediaTypeInfo.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IMediaTypeInfoImpl() {
    }

    protected IMediaTypeInfoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    public IMediaTypeInfoImpl(IUnknown that) throws ComException {
        super(that);
    }

    public IMediaTypeInfoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    public IMediaTypeInfoImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public BStr getType() throws ComException {
        BStr strType = new BStr();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strType == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strType)
            });

        return strType;
    }

    public BStr getSubtype() throws ComException {
        BStr strType = new BStr();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strType == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strType)
            });

        return strType;
    }

    public IID getIID() {
        return _iid;
    }

    public Object clone() {
        IMediaTypeInfoImpl that = null;

        try {
            that = new IMediaTypeInfoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
