/*
 * File:     IPinInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IPinInfo
 */
public class IPinInfoImpl extends IDispatchImpl implements IPinInfo {
    public static final String INTERFACE_IDENTIFIER = IPinInfo.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IPinInfoImpl() {
    }

    protected IPinInfoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    public IPinInfoImpl(IUnknown that) throws ComException {
        super(that);
    }

    public IPinInfoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    public IPinInfoImpl(CLSID clsid, IUnknownImpl pUnkOuter, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public IUnknown getPin() throws ComException {
        IUnknownImpl ppUnk = new IUnknownImpl();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public IDispatch getConnectedTo() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public IDispatch getConnectionMediaType() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public IDispatch getFilterInfo() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public BStr getName() throws ComException {
        BStr ppUnk = new BStr();
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(ppUnk)
            });

        return ppUnk;
    }

    public Int32 getDirection() throws ComException {
        Int32 ppDirection = new Int32();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppDirection == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(ppDirection)
            });

        return ppDirection;
    }

    public BStr getPinID() throws ComException {
        BStr strPinID = new BStr();
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strPinID == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(strPinID)
            });

        return strPinID;
    }

    public IDispatch getMediaTypes() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public void connect(IUnknown /*[in]*/ pPin) throws ComException {
        invokeStandardVirtualMethod(15, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pPin == null) ? (Parameter) PTR_NULL
                               : new Const((Parameter) pPin)
            });
    }

    public void connectDirect(IUnknown /*[in]*/ pPin) throws ComException {
        invokeStandardVirtualMethod(16, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pPin == null) ? (Parameter) PTR_NULL
                               : new Const((Parameter) pPin)
            });
    }

    public void connectWithType(IUnknown /*[in]*/ pPin,
        IDispatch /*[in]*/ pMediaType) throws ComException {
        invokeStandardVirtualMethod(17, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pPin == null) ? (Parameter) PTR_NULL
                               : new Const((Parameter) pPin),
                (pMediaType == null) ? (Parameter) PTR_NULL
                                     : new Const((Parameter) pMediaType)
            });
    }

    public void disconnect() throws ComException {
        invokeStandardVirtualMethod(18, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    public void render() throws ComException {
        invokeStandardVirtualMethod(19, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[0]);
    }

    public IID getIID() {
        return _iid;
    }

    public Object clone() {
        IPinInfoImpl that = null;

        try {
            that = new IPinInfoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
