/*
 * File:     IVideoWindowImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IVideoWindow
 */
public class IVideoWindowImpl extends IDispatchImpl implements IVideoWindow {
    public static final String INTERFACE_IDENTIFIER = IVideoWindow.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IVideoWindowImpl() {
    }

    protected IVideoWindowImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    public IVideoWindowImpl(IUnknown that) throws ComException {
        super(that);
    }

    public IVideoWindowImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    public IVideoWindowImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public void setCaption(BStr /*[in]*/ strCaption) throws ComException {
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strCaption == null) ? (Parameter) PTR_NULL
                                     : new Const(strCaption)
            });
    }

    public BStr getCaption() throws ComException {
        BStr strCaption = new BStr();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strCaption == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(strCaption)
            });

        return strCaption;
    }

    public void setWindowStyle(Int32 /*[in]*/ WindowStyle)
        throws ComException {
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { WindowStyle });
    }

    public Int32 getWindowStyle() throws ComException {
        Int32 WindowStyle = new Int32();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (WindowStyle == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(WindowStyle)
            });

        return WindowStyle;
    }

    public void setWindowStyleEx(Int32 /*[in]*/ WindowStyleEx)
        throws ComException {
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { WindowStyleEx });
    }

    public Int32 getWindowStyleEx() throws ComException {
        Int32 WindowStyleEx = new Int32();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (WindowStyleEx == null) ? (Parameter) PTR_NULL
                                        : new Pointer.OutOnly(WindowStyleEx)
            });

        return WindowStyleEx;
    }

    public void setAutoShow(Int32 /*[in]*/ AutoShow) throws ComException {
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { AutoShow });
    }

    public Int32 getAutoShow() throws ComException {
        Int32 AutoShow = new Int32();
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (AutoShow == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(AutoShow)
            });

        return AutoShow;
    }

    public void setWindowState(Int32 /*[in]*/ WindowState)
        throws ComException {
        invokeStandardVirtualMethod(15, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { WindowState });
    }

    public Int32 getWindowState() throws ComException {
        Int32 WindowState = new Int32();
        invokeStandardVirtualMethod(16, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (WindowState == null) ? (Parameter) PTR_NULL
                                      : new Pointer.OutOnly(WindowState)
            });

        return WindowState;
    }

    public void setBackgroundPalette(Int32 /*[in]*/ pBackgroundPalette)
        throws ComException {
        invokeStandardVirtualMethod(17, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pBackgroundPalette });
    }

    public Int32 getBackgroundPalette() throws ComException {
        Int32 pBackgroundPalette = new Int32();
        invokeStandardVirtualMethod(18, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pBackgroundPalette == null) ? (Parameter) PTR_NULL
                                             : new Pointer.OutOnly(
                    pBackgroundPalette)
            });

        return pBackgroundPalette;
    }

    public void setVisible(Int32 /*[in]*/ pVisible) throws ComException {
        invokeStandardVirtualMethod(19, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pVisible });
    }

    public Int32 getVisible() throws ComException {
        Int32 pVisible = new Int32();
        invokeStandardVirtualMethod(20, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pVisible == null) ? (Parameter) PTR_NULL
                                   : new Pointer.OutOnly(pVisible)
            });

        return pVisible;
    }

    public void setLeft(Int32 /*[in]*/ pLeft) throws ComException {
        invokeStandardVirtualMethod(21, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pLeft });
    }

    public Int32 getLeft() throws ComException {
        Int32 pLeft = new Int32();
        invokeStandardVirtualMethod(22, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pLeft == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(pLeft)
            });

        return pLeft;
    }

    public void setWidth(Int32 /*[in]*/ pWidth) throws ComException {
        invokeStandardVirtualMethod(23, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pWidth });
    }

    public Int32 getWidth() throws ComException {
        Int32 pWidth = new Int32();
        invokeStandardVirtualMethod(24, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth)
            });

        return pWidth;
    }

    public void setTop(Int32 /*[in]*/ pTop) throws ComException {
        invokeStandardVirtualMethod(25, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pTop });
    }

    public Int32 getTop() throws ComException {
        Int32 pTop = new Int32();
        invokeStandardVirtualMethod(26, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pTop == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    pTop)
            });

        return pTop;
    }

    public void setHeight(Int32 /*[in]*/ pHeight) throws ComException {
        invokeStandardVirtualMethod(27, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { pHeight });
    }

    public Int32 getHeight() throws ComException {
        Int32 pHeight = new Int32();
        invokeStandardVirtualMethod(28, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });

        return pHeight;
    }

    public void setOwner(LongPtr /*[in]*/ Owner) throws ComException {
        invokeStandardVirtualMethod(29, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Owner });
    }

    public LongPtr getOwner() throws ComException {
        LongPtr Owner = new LongPtr();
        invokeStandardVirtualMethod(30, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (Owner == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(Owner)
            });

        return Owner;
    }

    public void setMessageDrain(LongPtr /*[in]*/ Drain)
        throws ComException {
        invokeStandardVirtualMethod(31, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Drain });
    }

    public LongPtr getMessageDrain() throws ComException {
        LongPtr Drain = new LongPtr();
        invokeStandardVirtualMethod(32, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (Drain == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(Drain)
            });

        return Drain;
    }

    public Int32 getBorderColor() throws ComException {
        Int32 Color = new Int32();
        invokeStandardVirtualMethod(33, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (Color == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(Color)
            });

        return Color;
    }

    public void setBorderColor(Int32 /*[in]*/ Color) throws ComException {
        invokeStandardVirtualMethod(34, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Color });
    }

    public Int32 getFullScreenMode() throws ComException {
        Int32 FullScreenMode = new Int32();
        invokeStandardVirtualMethod(35, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (FullScreenMode == null) ? (Parameter) PTR_NULL
                                         : new Pointer.OutOnly(FullScreenMode)
            });

        return FullScreenMode;
    }

    public void setFullScreenMode(Int32 /*[in]*/ FullScreenMode)
        throws ComException {
        invokeStandardVirtualMethod(36, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { FullScreenMode });
    }

    public void setWindowForeground(Int32 /*[in]*/ Focus)
        throws ComException {
        invokeStandardVirtualMethod(37, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Focus });
    }

    public void notifyOwnerMessage(LongPtr /*[in]*/ hwnd, Int32 /*[in]*/ uMsg,
        LongPtr /*[in]*/ wParam, LongPtr /*[in]*/ lParam)
        throws ComException {
        invokeStandardVirtualMethod(38, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { hwnd, uMsg, wParam, lParam });
    }

    public void setWindowPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException {
        invokeStandardVirtualMethod(39, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { Left, Top, Width, Height });
    }

    public void getWindowPosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException {
        invokeStandardVirtualMethod(40, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pLeft == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(pLeft),
                (pTop == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    pTop),
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    public void getMinIdealImageSize(Int32 /*[out]*/ pWidth,
        Int32 /*[out]*/ pHeight) throws ComException {
        invokeStandardVirtualMethod(41, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    public void getMaxIdealImageSize(Int32 /*[out]*/ pWidth,
        Int32 /*[out]*/ pHeight) throws ComException {
        invokeStandardVirtualMethod(42, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    public void getRestorePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException {
        invokeStandardVirtualMethod(43, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pLeft == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly(pLeft),
                (pTop == null) ? (Parameter) PTR_NULL : new Pointer.OutOnly(
                    pTop),
                (pWidth == null) ? (Parameter) PTR_NULL
                                 : new Pointer.OutOnly(pWidth),
                (pHeight == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(pHeight)
            });
    }

    public void hideCursor(Int32 /*[in]*/ HideCursor) throws ComException {
        invokeStandardVirtualMethod(44, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] { HideCursor });
    }

    public Int32 isCursorHidden() throws ComException {
        Int32 CursorHidden = new Int32();
        invokeStandardVirtualMethod(45, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (CursorHidden == null) ? (Parameter) PTR_NULL
                                       : new Pointer.OutOnly(CursorHidden)
            });

        return CursorHidden;
    }

    public IID getIID() {
        return _iid;
    }

    public Object clone() {
        IVideoWindowImpl that = null;

        try {
            that = new IVideoWindowImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
