/*
 * File:     IMediaPositionVTBL.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.server;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.server.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.server.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents VTBL for COM interface IMediaPosition
 */
public class IMediaPositionVTBL extends IDispatchVTBL {
    public IMediaPositionVTBL(CoClassMetaInfo classMetaInfo) {
        super(classMetaInfo);

        addMembers(new VirtualMethodCallback[] {
                new VirtualMethodCallback("getDuration", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new DoubleFloat()) },
                    0),
                new VirtualMethodCallback("setCurrentPosition", new HResult(),
                    new Parameter[] { new DoubleFloat() }),
                new VirtualMethodCallback("getCurrentPosition", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new DoubleFloat()) },
                    0),
                new VirtualMethodCallback("getStopTime", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new DoubleFloat()) },
                    0),
                new VirtualMethodCallback("setStopTime", new HResult(),
                    new Parameter[] { new DoubleFloat() }),
                new VirtualMethodCallback("getPrerollTime", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new DoubleFloat()) },
                    0),
                new VirtualMethodCallback("setPrerollTime", new HResult(),
                    new Parameter[] { new DoubleFloat() }),
                new VirtualMethodCallback("setRate", new HResult(),
                    new Parameter[] { new DoubleFloat() }),
                new VirtualMethodCallback("getRate", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new DoubleFloat()) },
                    0),
                new VirtualMethodCallback("canSeekForward", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new Int32()) }, 0),
                new VirtualMethodCallback("canSeekBackward", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new Int32()) }, 0)
            });
    }
}
