/*
 * File:     IPinInfoVTBL.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.server;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.server.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.server.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents VTBL for COM interface IPinInfo
 */
public class IPinInfoVTBL extends IDispatchVTBL {
    public IPinInfoVTBL(CoClassMetaInfo classMetaInfo) {
        super(classMetaInfo);

        addMembers(new VirtualMethodCallback[] {
                new VirtualMethodCallback("getPin", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IUnknownImpl()) },
                    0),
                new VirtualMethodCallback("getConnectedTo", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("getConnectionMediaType",
                    new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("getFilterInfo", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("getName", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new BStr()) }, 0),
                new VirtualMethodCallback("getDirection", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new Int32()) }, 0),
                new VirtualMethodCallback("getPinID", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new BStr()) }, 0),
                new VirtualMethodCallback("getMediaTypes", new HResult(),
                    new Parameter[] { new Pointer.OutOnly(new IDispatchImpl()) },
                    0),
                new VirtualMethodCallback("connect", new HResult(),
                    new Parameter[] { new IUnknownImpl() }),
                new VirtualMethodCallback("connectDirect", new HResult(),
                    new Parameter[] { new IUnknownImpl() }),
                new VirtualMethodCallback("connectWithType", new HResult(),
                    new Parameter[] { new IUnknownImpl(), new IDispatchImpl() }),
                new VirtualMethodCallback("disconnect", new HResult(),
                    new Parameter[] {  }),
                new VirtualMethodCallback("render", new HResult(),
                    new Parameter[] {  })
            });
    }
}
