/*
 * File:     ElanMediaPlayer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.player;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocaleListener;

import mpi.eudico.client.mediacontrol.Controller;


/**
 * The elan media players methods
 */
public interface ElanMediaPlayer extends Controller, ElanLocaleListener {
    public mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor getMediaDescriptor();

    /**
     * DOCUMENT ME!
     */
    public void start();

    /**
     * DOCUMENT ME!
     */
    public void stop();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isPlaying();

    /**
     * DOCUMENT ME!
     *
     * @param startTime DOCUMENT ME!
     * @param stopTime DOCUMENT ME!
     */
    public void playInterval(long startTime, long stopTime);

    public void setStopTime(long stopTime);

    /**
     * DOCUMENT ME!
     *
     * @param offset DOCUMENT ME!
     */
    public void setOffset(long offset);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getOffset();

    public void nextFrame();

    public void previousFrame();

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setMediaTime(long time);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaTime();

    /**
     * DOCUMENT ME!
     *
     * @param rate DOCUMENT ME!
     */
    public void setRate(float rate);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getRate();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaDuration();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getVolume();

    /**
     * DOCUMENT ME!
     *
     * @param level DOCUMENT ME!
     */
    public void setVolume(float level);

    /**
     * DOCUMENT ME!
     *
     * @param layoutManager DOCUMENT ME!
     */
    public void setLayoutManager(ElanLayoutManager layoutManager);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public java.awt.Component getVisualComponent();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getAspectRatio();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMilliSecondsPerSample();

    /**
     * DOCUMENT ME!
     *
     * @param milliSeconds DOCUMENT ME!
     */
    public void setMilliSecondsPerSample(long milliSeconds); // temporary, player should do this 

    /**
     * DOCUMENT ME!
     */
    public void updateLocale();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getFrameworkDescription();

    /**
     * DOCUMENT ME!
     *
     * @param controller DOCUMENT ME!
     */
    public void addController(Controller controller);

    /**
     * DOCUMENT ME!
     *
     * @param controller DOCUMENT ME!
     */
    public void removeController(Controller controller);

    /**
     * DOCUMENT ME!
     */
    public void startControllers();

    /**
     * DOCUMENT ME!
     */
    public void stopControllers();

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setControllersMediaTime(long time);

    /**
     * DOCUMENT ME!
     *
     * @param rate DOCUMENT ME!
     */
    public void setControllersRate(float rate);

    public void cleanUpOnClose();
}
