/*
 * File:     EAFType.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.model;

import mpi.eudico.client.annotator.search.query.viewer.EAFPopupMenu;

import mpi.search.content.model.CorpusType;

import java.util.List;
import java.util.Locale;


/**
 * Generic EAF-Implementation of the SearchableType-Interface. Aimed at
 * describing a minimal set of tiers present in every eaf-file; relevant when
 * searching through different eaf-files -> future purpose
 *
 * @author Alexander Klassmann
 * @version april 2004
 */
public class EAFType extends CorpusType {
    public EAFType() {
        frameTitle = "Elan Search";
    }

    /**
     * DOCUMENT ME!
     *
     * @param fieldType DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public List getClosedVoc(String tierName) {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param fieldType DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isClosedVoc(String tierName) {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @param closedVoc DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isClosedVocEditable(List closedVoc) {
        return false;
    }

    public boolean allowsSearchOverMultipleTiers() {
        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @param fieldType DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Locale getDefaultLocale(String tierName) {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param fieldType DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String[] getRelatedTiers(String tierName) {
        return tierNames;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDefaultUnit() {
        return standardUnit;
    }

    /**
     * DOCUMENT ME!
     *
     * @param fieldType DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean strictCaseSensitive(String tierName) {
        return false;
    }

    public String[] getIndexTierNames() {
        return new String[0];
    }

    public boolean hasAttributes() {
        return false;
    }

    public String[] getAttributeNames(String tierName) {
        return new String[0];
    }

    public String getToolTipTextForAttribute(String attributeName) {
        return "";
    }

    public Object getPossibleAttributeValues(String tierName,
        String attributeName) {
        return null;
    }

    public Class getInputMethodClass() {
        return EAFPopupMenu.class;
    }

    public boolean allowsQuantifierNO() {
        return true;
    }

    public boolean allowsTemporalConstraints() {
        return true;
    }
}
