/*
 * File:     EAFPopupMenu.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.query.viewer;

import mpi.eudico.client.im.ImUtil;

import mpi.search.content.query.viewer.AbstractConstraintPanel;
import mpi.search.content.query.viewer.AbstractPopupMenu;

import java.awt.Component;
import java.awt.event.*;

import java.util.Locale;

import javax.swing.JMenuItem;


/**
 * Created on Aug 18, 2004
 * @author Alexander Klassmann
 * @version Aug 18, 2004
 */
public class EAFPopupMenu extends AbstractPopupMenu implements FocusListener {
    final static private Locale[] imLocales = ImUtil.getLanguages();

    public EAFPopupMenu(Component component,
        AbstractConstraintPanel constraintPanel) {
        super(component, constraintPanel);
    }

    public void fillMenu() {
        setLabel("Select Language");

        try {
            JMenuItem item;

            for (int i = 0; i < imLocales.length; i++) {
                item = new JMenuItem(imLocales[i].getDisplayName());
                add(item);
                item.addActionListener(this);
            }

            component.addFocusListener(this);
        } catch (java.lang.NoSuchMethodError nsme) {
            System.err.println(
                "No input methods found. Probably class ImUtil not in java.lib.ext");
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (javax.swing.SwingUtilities.isRightMouseButton(e) ||
                e.isPopupTrigger()) {
            show(component, e.getX(), e.getY());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();

        for (int i = 0; i < imLocales.length; i++) {
            if (command.equals(imLocales[i].getDisplayName())) {
                ImUtil.setLanguage(component, imLocales[i]);

                break;
            }
        }
    }

    public void focusGained(FocusEvent e) {
        ImUtil.setLanguage(component, component.getLocale());
    }

    public void focusLost(FocusEvent e) {
    }
}
