/*
 * File:     EAFMultipleFileMatch.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.result.model;

import mpi.search.content.result.model.AbstractContentMatch;


/**
 * Created on Aug 17, 2004
 * @author Alexander Klassmann
 * @version Aug 17, 2004
 */
public class EAFMultipleFileMatch extends AbstractContentMatch {
    final private String value;
    private String id;

    public EAFMultipleFileMatch(String value) {
        this.value = value;
    }

    public EAFMultipleFileMatch(String id, String value) {
        this.id = id;
        this.value = value;
    }

    public void setFileName(String s) {
        fileName = s;
    }

    public void setTierName(String s) {
        tierName = s;
    }

    public void setLeftContext(String s) {
        leftContext = s;
    }

    public void setRightContext(String s) {
        rightContext = s;
    }

    public void setBeginTimeBoundary(long time) {
        beginTime = time;
    }

    public void setEndTimeBoundary(long time) {
        endTime = time;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.server.corpora.clom.AnnotationCore#getValue()
     */
    public String getValue() {
        return value;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMatchedSubstringIndices(int[][] substringIndices) {
        this.matchedSubstringIndices = substringIndices;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }
}
