/*
 * File:     ElanMatch.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.result.model;

import mpi.eudico.server.corpora.clom.Annotation;

import mpi.search.content.result.model.AbstractContentMatch;


/**
 * Created on Jul 22, 2004
 * @author Alexander Klassmann
 * @version Jul 22, 2004
 */
public class ElanMatch extends AbstractContentMatch {
    final private Annotation annotation;

    public ElanMatch(Annotation annotation) {
        this.annotation = annotation;
    }

    public ElanMatch(Annotation annotation, int index) {
        this(annotation);
        setIndex(index);
    }

    public ElanMatch(Annotation annotation, int index, int[][] substringIndices) {
        this(annotation, index);
        setMatchedSubstringIndices(substringIndices);
    }

    public ElanMatch(Annotation annotation, int index, String leftContext,
        String rightContext, int[][] substringIndices) {
        this(annotation, index);
        setLeftContext(leftContext);
        setRightContext(rightContext);
        setMatchedSubstringIndices(substringIndices);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getTierName()
     */
    public String getTierName() {
        String name = "";

        try {
            name = annotation.getTier().getName();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return name;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getValue()
     */
    public String getValue() {
        return annotation.getValue();
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getBeginTime()
     */
    public long getBeginTimeBoundary() {
        return annotation.getBeginTimeBoundary();
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Result#getEndTime()
     */
    public long getEndTimeBoundary() {
        return annotation.getEndTimeBoundary();
    }

    public Annotation getAnnotation() {
        return annotation;
    }

    public void setLeftContext(String context) {
        leftContext = context;
    }

    public void setRightContext(String context) {
        rightContext = context;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMatchedSubstringIndices(int[][] substringIndices) {
        this.matchedSubstringIndices = substringIndices;
    }

    public String getId() {
        return null;
    }
}
