/*
 * File:     EAFResultViewerGridRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.annotator.grid.GridRenderer;

import mpi.eudico.client.annotator.search.result.model.ElanMatch;

import mpi.eudico.client.annotator.viewer.AbstractViewer;

import mpi.eudico.util.TimeRelation;

import mpi.search.content.result.model.ContentMatch;

import mpi.search.viewer.ResultTextPane;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;


/**
 * Renders textPanes instead of labels (for highlighting of found matches)
 * Created on Oct 22, 2004
 *
 * @author Alexander Klassmann
 * @version Oct 22, 2004
 */
public class EAFResultViewerGridRenderer extends GridRenderer {
    final private ResultTextPane textPane;

    public EAFResultViewerGridRenderer(AbstractTableModel tableModel) {
        this(null, tableModel);
    }

    /**
     * @param viewer
     * @param tableModel
     */
    public EAFResultViewerGridRenderer(AbstractViewer viewer,
        AbstractTableModel tableModel) {
        super(viewer, tableModel);

        // override the defaults for performance reasons
        textPane = new ResultTextPane() {
                    public void validate() {
                    }

                    public void revalidate() {
                    }

                    public void firePropertyChange(String propertyName,
                        boolean oldValue, boolean newValue) {
                    }

                    //must not be overriden - otherwise no text is shown at all
                    //protected void firePropertyChange(
                    //		String propertyName,
                    //		Object oldValue,
                    //		Object newValue) {
                    //		}
                };

        //setting highlighted parts bold, but no special colour is set
        textPane.setHighlightedBold(true);
    }

    /**
     * Returns a configured JLabel for every cell in the table.
     *
     * @param table
     *            the table
     * @param value
     *            the cell value
     * @param isSelected
     *            selected state of the cell
     * @param hasFocus
     *            whether or not the cell has focus
     * @param row
     *            the row index
     * @param column
     *            the column index
     *
     * @return this JLabel
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ContentMatch) {
            boolean isInSelection = isSelected;

            if (viewer != null) {
                isInSelection = TimeRelation.overlaps((ContentMatch) value,
                        viewer.getSelectionBeginTime(),
                        viewer.getSelectionEndTime());
            }

            boolean isActive = false;

            if ((viewer != null) && value instanceof ElanMatch) {
                isActive = viewer.getActiveAnnotation() == ((ElanMatch) value).getAnnotation();
            }

            setComponentLayout(textPane, table, isInSelection, isActive);

            textPane.reset();

            textPane.appendString(((ContentMatch) value).getValue(),
                ((ContentMatch) value).getMatchedSubstringIndices());

            textPane.setToolTipText(((ContentMatch) value).getValue());

            return textPane;
        }

        return super.getTableCellRendererComponent(table, value, isSelected,
            hasFocus, row, column);
    }
}
