/*
 * File:     EAFResultViewerTableModel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.annotator.grid.GridViewerTableModel;

import mpi.eudico.client.annotator.search.result.model.ElanMatch;

import mpi.eudico.server.corpora.clom.AnnotationCore;

import mpi.search.content.result.model.ContentMatch;


/**
 * Created on Aug 24, 2004
 *
 * @author Alexander Klassmann
 * @version Aug 24, 2004
 */
public class EAFResultViewerTableModel extends GridViewerTableModel {
    private int[] restrictedInterval;

    /**
     * Creates a new EAFResultViewerTableModel object.
     */
    public EAFResultViewerTableModel() {
        usedColumnNames.add(2, GridViewerTableModel.FILENAME);
        usedColumnNames.add(3, GridViewerTableModel.TIERNAME);
        usedColumnNames.add(4, GridViewerTableModel.LEFTCONTEXT);
        usedColumnNames.add(6, GridViewerTableModel.RIGHTCONTEXT);
    }

    /**
     * DOCUMENT ME!
     *
     * @param row DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public AnnotationCore getAnnotationCore(int row) {
        AnnotationCore annotationCore = super.getAnnotationCore(row);

        return (annotationCore instanceof ElanMatch)
        ? ((ElanMatch) annotationCore).getAnnotation() : annotationCore;
    }

    /**
     * Returns whether or not the cell at the given row and column  can be edited.
     *
     * @param row the row index
     * @param column the column index
     *
     * @return true if the cell can be edited, false otherwise
     */
    public boolean isCellEditable(int row, int column) {
        return getValueAt(row, column) instanceof ElanMatch;
    }

    /**
     * DOCUMENT ME!
     *
     * @param interval
     */
    public void setRestrictionInterval(int[] interval) {
        if (interval != null) {
            if ((1 <= interval[0]) && (interval[0] <= interval[1]) &&
                    (interval[1] <= annotations.size())) {
                restrictedInterval = interval;
                isFiltering = true;
                fireTableDataChanged();
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getRowCount() {
        return (isFiltering && (restrictedInterval != null))
        ? (restrictedInterval[1] - restrictedInterval[0] + 1)
        : super.getRowCount();
    }

    /**
     * Returns the value for the table cell at the specified row and column.
     *
     * @param row the row index
     * @param column the column index
     *
     * @return the value that has to be rendered
     */
    public Object getValueAt(int row, int column) {
        if (annotations.get(row) instanceof ContentMatch) {
            if (isFiltering) {
                row += (restrictedInterval[0] - 1);
            }

            ContentMatch match = (ContentMatch) annotations.get(row);

            String cn = getColumnName(column);

            if (cn.equals(GridViewerTableModel.ANNOTATION)) {
                return match;
            }

            if (cn.equals(GridViewerTableModel.FILENAME)) {
                return match.getFileName();
            }

            if (cn.equals(GridViewerTableModel.TIERNAME)) {
                return match.getTierName();
            }

            if (cn.equals(GridViewerTableModel.LEFTCONTEXT)) {
                return match.getLeftContext();
            }

            if (cn.equals(GridViewerTableModel.RIGHTCONTEXT)) {
                return match.getRightContext();
            }
        }

        return super.getValueAt(row, column);
    }
}
