/*
 * File:     ElanResultViewer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.annotator.grid.AbstractEditableGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import mpi.eudico.server.corpora.util.ACMEditEvent;

import mpi.search.content.result.model.ContentMatch;
import mpi.search.content.result.model.ContentResult;

import mpi.search.model.Match;
import mpi.search.model.Result;
import mpi.search.model.ResultEvent;

import mpi.search.viewer.ResultViewer;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.TableCellRenderer;


/**
 * $Id: ElanResultViewer.java,v 1.2 2005/08/17 13:25:53 hasloe Exp $
 *
 * @author $Author: hasloe $
 * @version $Revision: 1.2 $
 */
public class ElanResultViewer extends AbstractEditableGridViewer
    implements ResultViewer {
    private ContentResult result;

    /**
     * Creates a new ElanResultViewer object.
     */
    public ElanResultViewer() {
        super(new AnnotationTable(new EAFResultViewerTableModel()));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected TableCellRenderer createTableCellRenderer() {
        return new EAFResultViewerGridRenderer(this, dataModel);
    }

    /**
     * DOCUMENT ME!
     *
     * @param columnName DOCUMENT ME!
     * @param visible DOCUMENT ME!
     */
    public void setColumnVisible(String columnName, boolean visible) {
        table.setColumnVisible(columnName, visible);
    }

    /**
     * DOCUMENT ME!
     *
     * @param list DOCUMENT ME!
     */
    public void setData(List list) {
        updateDataModel(list);
        updateSelection();
        doUpdate();
    }

    /**
     * DOCUMENT ME!
     *
     * @param e DOCUMENT ME!
     */
    public void resultChanged(ResultEvent e) {
        result = (ContentResult) e.getSource();

        if (result.getMatchCount() == 0) {
            reset();
        } else {
            if (e.getType() == ResultEvent.MATCH_ADDED) {
                showMatch(result.getLastMatch());
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param result DOCUMENT ME!
     */
    public void showResult(Result result) {
        this.result = (ContentResult) result;
        setData(result.getMatches());
    }

    /**
     * DOCUMENT ME!
     *
     * @param match DOCUMENT ME!
     */
    public void showMatch(Match match) {
        dataModel.addAnnotation((ContentMatch) match);
    }

    /**
     * DOCUMENT ME!
     */
    public void reset() {
        setData(new ArrayList());
    }

    /**
     * Checks the kind of edit that has happened and updates the table when necessary.
     *
     * @param e the ACMEditEvent
     */
    public void ACMEdited(ACMEditEvent e) {
        if ((result == null) || (result.getTierNames().length == 0)) {
            return;
        }

        TierImpl changedTier;

        switch (e.getOperation()) {
        case ACMEditEvent.ADD_TIER:
            break;

        case ACMEditEvent.ADD_ANNOTATION_BEFORE:
            break;

        case ACMEditEvent.ADD_ANNOTATION_AFTER:
            break;

        case ACMEditEvent.CHANGE_ANNOTATIONS:

        // fallthrough
        case ACMEditEvent.REMOVE_ANNOTATION:
            repaint();

            break;

        case ACMEditEvent.CHANGE_TIER:

            // a tier is invalidated the kind of change is unknown
            changedTier = (TierImpl) e.getInvalidatedObject();

        case ACMEditEvent.REMOVE_TIER:
            changedTier = (TierImpl) e.getModification();

            for (int i = 0; i < result.getTierNames().length; i++) {
                try {
                    if (result.getTierNames()[i].equals(changedTier.getName())) {
                        result.reset();

                        break;
                    }
                } catch (Exception er) {
                }
            }

            break;

        default:
            super.ACMEdited(e);
        }
    }
}
