/*
 * File:     EAFStructuredSearchMultipleFileFrame.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.search.viewer;

import mpi.eudico.client.annotator.ElanFrame2;

import mpi.search.SearchLocale;

import javax.swing.JFrame;


public class EAFStructuredSearchMultipleFileFrame extends JFrame {
    // vervangen door structured search panel
    EAFMultipleFileSearchPanel searchPanel;

    public EAFStructuredSearchMultipleFileFrame(ElanFrame2 elanFrame) {
        super(SearchLocale.getString("MultipleFileSearch.Title"));
        searchPanel = new EAFMultipleFileSearchPanel(elanFrame);
        getContentPane().add(searchPanel);
        pack();
        setVisible(true);
    }

    // moet vanuit Elan worden aangeroepen
    // GEEN NIEUWE ELANS creeeren vanuit result list maar alles binnen de
    // huidige runtime houden
    static public void main(String[] args) {
        new EAFStructuredSearchMultipleFileFrame(null);
    }
}
