/*
 * File:     TSTestFrame.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries;

import mpi.eudico.client.annotator.Constants;

import mpi.eudico.client.annotator.viewer.*;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;

import javax.swing.JFrame;


/**
 * Test Frame for Time Series track viewer.
 *
 * @author Han Sloetjes
 */
public class TSTestFrame extends JFrame {
    public TSTestFrame() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Track viewer");
        initComponents();
        setSize(500, 400);
    }

    private void initComponents() {
        float[] range = new float[] { 2, 10 };
        ContinuousRateTSTrack track = createDummyTrack(range, 25f);
        ContinuousRateTSTrack track2 = createDummyTrack(range, 150f);
        track2.setColor(Color.ORANGE);

        TSTrackPanelImpl panel = new TSTrackPanelImpl();
        panel.setMargin(new Insets(3, 3, 3, 0));
        panel.setHeight(300);
        panel.setWidth(450);

        TSRulerImpl ruler = new TSRulerImpl(range, 30, 200);
        ruler.setFont(Constants.SMALLFONT);
        ruler.setUnitString("m/s2");
        panel.setRuler(ruler);

        panel.addTrack(track2);
        panel.addTrack(track);

        TSTrackPanelImpl panel2 = new TSTrackPanelImpl();
        panel2.setMargin(new Insets(3, 3, 3, 0));
        panel2.setHeight(300);
        panel2.setWidth(450);

        TSRulerImpl ruler2 = new TSRulerImpl(new float[] { 0.0f, 60f }, 30, 200);
        ruler2.setFont(Constants.SMALLFONT);
        ruler2.setUnitString("m/s");
        panel2.setRuler(ruler2);

        TSTrackPanelImpl panel3 = new TSTrackPanelImpl();
        panel3.setMargin(new Insets(3, 3, 3, 0));
        panel3.setHeight(300);
        panel3.setWidth(450);

        TSRulerImpl ruler3 = new TSRulerImpl(new float[] { 0.0f, 60f }, 30, 200);
        ruler3.setFont(Constants.SMALLFONT);
        ruler3.setUnitString("xxx");
        panel3.setRuler(ruler3);

        TimeSeriesViewer viewer = new TimeSeriesViewer();
        viewer.addTSTrackPanel(panel);
        viewer.addTSTrackPanel(panel2);
        viewer.addTSTrackPanel(panel3);
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(viewer);
    }

    private ContinuousRateTSTrack createDummyTrack(float[] range, float rate) {
        ContinuousRateTSTrack track = new ContinuousRateTSTrack();
        track.setType(TimeSeriesTrack.VALUES_FLOAT_ARRAY);
        track.setRange(range);
        track.setColor(Color.MAGENTA);
        track.setSampleRate(rate);

        float[] data = new float[(int) (rate * 10)];
        float val = (range[1] - range[0]) / 2;
        float dif = (range[1] - range[0]) / 10;

        for (int i = 0; i < data.length; i++) {
            data[i] = val;

            if (dif > 0) {
                if ((val + dif) > range[1]) {
                    dif = -dif;
                }
            } else {
                if ((val + dif) < range[0]) {
                    dif = -dif;
                }
            }

            val += dif;
        }

        track.setData(data);

        return track;
    }

    public static void main(String[] args) {
        new TSTestFrame().setVisible(true);
    }
}
