/*
 * File:     TSTrackPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries;

import java.awt.Insets;

import java.util.List;


/**
 * Defines a panel that can visualize multiple timeseries tracks, with vertical
 * ruler etc.
 */
public interface TSTrackPanel {
    /**
     * Adds a track to the panel.
     *
     * @param track the track to add to the panel
     */
    public void addTrack(AbstractTSTrack track);

    /**
     * Removes a track from the panel.
     *
     * @param track the track to remove from the panel
     *
     * @return true if the track was in the list of tracks and has been
     *         removed, false otherwise
     */
    public boolean removeTrack(AbstractTSTrack track);

    /**
     * Removes a track identified by trackID from the panel.
     *
     * @param trackID the name or id of the track to remove from the panel
     *
     * @return true if the track was in the list of tracks and has been
     *         removed, false otherwise
     */
    public boolean removeTrack(String trackID);

    /**
     * Returns the track identified by trackID.
     *
     * @param trackID the name or id of the track
     *
     * @return the track, or null if not present in the list
     */
    public AbstractTSTrack getTrack(String trackID);

    /**
     * Returns the list of tracks in this panel.
     *
     * @return the list of tracks
     */
    public List getTracks();

    /**
     * Sets the display height for this panel.
     *
     * @param height the new height
     */
    public void setHeight(int height);

    /**
     * Returns the height of this panel.
     *
     * @return the height of this panel
     */
    public int getHeight();

    /**
     * Sets the display width of this panel.
     *
     * @param width the new width
     */
    public void setWidth(int width);

    /**
     * Returns the width of the panel.
     *
     * @return the width of the panel
     */
    public int getWidth();

    /**
     * Sets the margin of this panel.
     *
     * @param insets an Insets object containing the margin
     */
    public void setMargin(Insets insets);

    /**
     * Returns the margin in an Insets object.
     *
     * @return the margin in an Insets object
     */
    public Insets getMargin();
}
