/*
 * File:     TimeSeriesChangeListener.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries;

import java.util.EventListener;


/**
 * Defines a listener to TimeSeriesChangeEvents.
 *
 * @author Han Sloetjes
 */
public interface TimeSeriesChangeListener extends EventListener {
    /**
     * A time series object has changed. Can be a track or configuration object.
     *
     * @param event the change event
     */
    public void timeSeriesChanged(TimeSeriesChangeEvent event);
}
