/*
 * File:     TimeSeriesConstants.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries;


/**
 * @author Han Sloetjes
 */
public interface TimeSeriesConstants {
    public static final String FIXED_RATE = "Fixed rate";
    public static final String VARIABLE_RATE = "Variable rate";
    public static final String UNKNOWN_RATE_TYPE = "Unknown";
    public static final String DISCONTINUOUS_RATE = "Discontinuous Rate";
    public static final String CONTINUOUS_RATE = "Continuous Rate";

    // keys for storage of properties
    public static final String AUTO_DETECT_RANGE = "detect-range";
    public static final String SAMPLE_POS = "pos";

    // configuration xml strings

    /** file suffix */
    public static final String CONF_SUFFIX = "_tsconf.xml";
    public static final String TIMESERIES = "timeseries";
    public static final String DATE = "date";
    public static final String VERS = "version";
    public static final String SOURCE = "tracksource";
    public static final String URL = "source-url";
    public static final String ORIGIN = "time-origin";
    public static final String SAMPLE_TYPE = "sample-type";
    public static final String PROVIDER = "provider";
    public static final String PROP = "property";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String TRACK = "track";
    public static final String NAME = "name";
    public static final String DERIVATION = "derivative";
    public static final String DESC = "description";
    public static final String UNITS = "units";
    public static final String POSITION = "sample-position";
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String RANGE = "range";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String DATA_TYPE = "data-type";
    public static final String COLOR = "color";
}
