/*
 * File:     TSConfiguration.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries.config;

import java.util.Enumeration;
import java.util.Set;


/**
 * Interface for TimeSeries objects configuration.
 *
 * @author Han Sloetjes
 */
public interface TSConfiguration {
    /**
     * Sets a property.
     *
     * @param key a key
     * @param value the value
     */
    public void setProperty(String key, String value);

    /**
     * Returns a property.
     *
     * @param key the key
     *
     * @return the value or null
     */
    public String getProperty(String key);

    /**
     * Removes a property (key and value).
     *
     * @param key the key
     *
     * @return the removed value or null
     */
    public Object removeProperty(String key);

    /**
     * Returns an enumeration of the keys in the properties.
     *
     * @return a key enumeration
     */
    public Enumeration propertyNames();

    /**
     * Adds an object, a configuration or a track e.g., to a map of objects.
     *
     * @param key an identifier
     * @param value a timeseries object
     */
    public void putObject(Object key, Object value);

    /**
     * Returns an object for the specified key.
     *
     * @param key an identifier
     *
     * @return an object or null
     */
    public Object getObject(Object key);

    /**
     * Removes the key and value from the properties map.
     *
     * @param key an identifier
     *
     * @return the removed object or null
     */
    public Object removeObject(Object key);

    /**
     * Returns the keys contained in the object map
     *
     * @return the keys in the object map
     */
    public Set objectKeySet();
}
