/*
 * File:     TSConfigPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.timeseries.spi;

import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeListener;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;

import javax.swing.JComponent;


/**
 * A Container class that can be added to a Dialog or Frame and that enables
 * selection and/or configuration of time series track from a source file.
 *
 * @author Han Sloetjes
 */
public abstract class TSConfigPanel extends JComponent {
    /**
     * Registers a listener for TimeSeriesChangeEvents.  After changes in
     * configuration (new track defined, track attributes changed etc)
     * listeners can/should be informed of the changes.
     *
     * @param l a listener for TimeSeriesChangeEvents
     */
    public abstract void addTimeSeriesChangeListener(TimeSeriesChangeListener l);

    /**
     * Sets the configuration object (containing a link to the source) that
     * needs to be configured.
     *
     * @param tssc the source configuration object
     */
    public abstract void setSourceConfiguration(TSSourceConfiguration tssc);
}
