/*
 * File:     SystemReporting.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.util;

import mpi.library.util.LogUtil;

import java.io.File;

import java.util.logging.Logger;


public class SystemReporting {
    public static final String OS_NAME;
    public static final String USER_HOME;
    private static final Logger LOG = Logger.getLogger(SystemReporting.class.getName());

    static {
        OS_NAME = System.getProperty("os.name");
        USER_HOME = System.getProperty("user.home");
    }

    public static void printProperty(String prop) {
        System.out.println(prop + " = " + System.getProperty(prop));
    }

    /**
     *  @return lib/ext directory.
     */
    public static File getLibExtDir() {
        if (OS_NAME.startsWith("Mac OS X")) {
            return verifyMacUserLibExt();
        } else {
            return new File(System.getProperty("java.home") + File.separator +
                "lib" + File.separator + "ext");
        }
    }

    /**
       @return files from lib/ext. May be null.
    */
    public static File[] getLibExt() {
        File ext = SystemReporting.getLibExtDir();

        if ((ext != null) && ext.exists()) {
            return SystemReporting.getLibExtDir().listFiles();
        } else {
            return null;
        }
    }

    private static File verifyMacUserLibExt() {
        // im jars will be stored in the user home library ext dir
        String userLibJavaExt = USER_HOME + "/Library/Java/Extensions";

        File userLibExt = new File(userLibJavaExt);

        //System.out.println("Home lib ext: " + userLibJavaExt);
        if (!userLibExt.exists()) {
            try {
                boolean success = userLibExt.mkdirs();

                if (!success) {
                    LOG.warning("Unable to create folder: " + userLibExt);

                    return null;
                }
            } catch (SecurityException se) {
                LOG.warning("Unable to create folder: " + userLibExt);
                LOG.warning(LogUtil.formatStackTrace(se));

                return null;
            }
        }

        return userLibExt;
    }

    /**
       report files from lib/ext
    */
    public static void printLibExt() {
        File[] potext = getLibExt();
        int NOFfiles = (potext == null) ? 0 : potext.length;
        System.out.println("Found " + NOFfiles + " potential extension(s)");

        for (int i = 0; i < NOFfiles; i++) {
            System.out.println("\t" + potext[i]);
        }
    }

    /**
       testing
     */
    public static void main(String[] args) throws Exception {
        printProperty("java.home");
        printLibExt();
    }
}
