/*
 * File:     Tier2D.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.util;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import java.util.ArrayList;
import java.util.Iterator;


/**
 * Stores a Tier and has some additional display specific fields.
 *
 * @author Han Sloetjes
 * @version 0.1 10/7/2003
 */
public class Tier2D {
    private TierImpl tier;
    private ArrayList tags;
    private String name;
    private boolean isActiveTier;

    //private boolean isVisible; //may not be needed

    /**
     * Creates a new Tier2D instance
     *
     * @param tier DOCUMENT ME!
     */
    public Tier2D(TierImpl tier) {
        this.tier = tier;
        name = tier.getName();

        isActiveTier = false;

        //isVisible = true;
        tags = new ArrayList(20);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public TierImpl getTier() {
        return tier;
    }

    /**
     * DOCUMENT ME!
     *
     * @param tag DOCUMENT ME!
     */
    public void addTag(Tag2D tag) {
        tags.add(tag);
        tag.setTier2D(this);
    }

    /**
     * Insert the Tag2D into the list.<br>
     * Determine the right index by means of the x position.
     *
     * @param tag the Tag2D to insert
     */
    public void insertTag(Tag2D tag) {
        tag.setTier2D(this);

        Tag2D t1;
        Tag2D t2;

        for (int i = 0; i < tags.size(); i++) {
            t1 = (Tag2D) tags.get(i);

            if (((i == 0) || (i == (tags.size() - 1))) &&
                    (tag.getX() < t1.getX())) {
                tags.add(i, tag);

                return;
            }

            if (i < (tags.size() - 1)) {
                t2 = (Tag2D) tags.get(i + 1);

                if ((tag.getX() > t1.getX()) && (tag.getX() < t2.getX())) {
                    tags.add(i + 1, tag);

                    return;
                }
            }
        }

        tags.add(tag);
    }

    /**
     * DOCUMENT ME!
     *
     * @param tag DOCUMENT ME!
     */
    public void removeTag(Tag2D tag) {
        tags.remove(tag);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator getTags() {
        return tags.iterator();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ArrayList getTagsList() {
        return tags;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return name;
    }

    /**
     * Update the name of this Tier2D object after a change in the name of the
     * Tier.
     */
    public void updateName() {
        String old = name;

        if (!old.equals(tier.getName())) {
            name = tier.getName();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param active DOCUMENT ME!
     */
    public void setActive(boolean active) {
        isActiveTier = active;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isActive() {
        return isActiveTier;
    }
}
