/*
 * File:     TimeShiftRecord.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.util;


/**
 * A utility class to store old and new begin and end times of an annotation
 * that has  been moved.
 *
 * @author Han Sloetjes
 */
public class TimeShiftRecord {
    /** old begintime value */
    public final long oldBegin;

    /** old endtime value */
    public final long oldEnd;

    /** new begintime value */
    public final long newBegin;

    /** new endtime value */
    public final long newEnd;

    /** the time distance between old and new times */
    public final int shift;

    /**
     * Creates a new TimeShiftRecord instance.
     *
     * @param oldBegin old begin value
     * @param oldEnd old end value
     * @param shiftDistance the displacement in ms
     */
    public TimeShiftRecord(long oldBegin, long oldEnd, int shiftDistance) {
        this.oldBegin = oldBegin;
        this.oldEnd = oldEnd;
        this.shift = shiftDistance;

        if ((oldBegin + shiftDistance) < 0) {
            newBegin = 0;
        } else {
            newBegin = oldBegin + shiftDistance;
        }

        if ((oldEnd + shiftDistance) < 0) {
            newEnd = 0;
        } else {
            newEnd = oldEnd + shiftDistance;
        }
    }
}
