/*
 * File:     AnnotationDensityViewer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.viewer;

import mpi.eudico.client.mediacontrol.ControllerEvent;

import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

import mpi.eudico.server.corpora.util.ACMEditEvent;
import mpi.eudico.server.corpora.util.ACMEditListener;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

import java.util.Vector;


/**
 * DOCUMENT ME!
 * $Id: AnnotationDensityViewer.java,v 1.3 2005/08/18 10:09:17 klasal Exp $
 * @author $Author: klasal $
 * @version $Revision: 1.3 $
 */
public class AnnotationDensityViewer extends AbstractViewer
    implements ACMEditListener {
    private static Dimension SLIDERDIMENSION = new Dimension(600, 30);

    /** Holds value of property DOCUMENT ME! */
    final private int imageHeight = 5;
    private int imageWidth;
    private Transcription transcription;
    private BufferedImage bi;
    private Graphics2D big2d;
    private BufferedImage displayImage;

    /**
     * Constructor
     *
     * @param transcription DOCUMENT ME!
     */
    public AnnotationDensityViewer(Transcription transcription) {
        super();

        this.transcription = transcription;

        setPreferredSize(SLIDERDIMENSION);

        paintBuffer();
    }

    /**
     * Sets minimum size of the slider See also getPreferredSize
     *
     * @return DOCUMENT ME!
     */
    public Dimension getMinimumSize() {
        return SLIDERDIMENSION;
    }

    /**
     * Sets minimum size of the slider See also getMinimumSize
     *
     * @return DOCUMENT ME!
     */
    public Dimension getPreferredSize() {
        return SLIDERDIMENSION;
    }

    private void paintBuffer() {
        if (getWidth() > 0) {
            imageWidth = getWidth();
        } else {
            imageWidth = SLIDERDIMENSION.width;
        }

        bi = new BufferedImage(imageWidth, imageHeight,
                BufferedImage.TYPE_INT_RGB);
        big2d = bi.createGraphics();

        //big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
        //    RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        //paint the background color
        big2d.setColor(Color.lightGray);

        //complete rectangle
        big2d.fillRect(0, 0, imageWidth, imageHeight);
        big2d.setColor(Color.white);

        //upper line
        big2d.fillRect(0, 0, imageWidth, 1);

        //left line
        big2d.drawLine(0, 0, 0, imageHeight);
        big2d.setColor(Color.darkGray);

        //lower line
        big2d.fillRect(0, imageHeight - 1, imageWidth, 1);

        //paint the vertical line where the annotations are
        big2d.setColor(Color.darkGray.brighter());

        Vector vTiers = new Vector(0);
        Vector annotations = null;
        TierImpl tier;
        Annotation ann;
        int begintime;
        int endtime;
        int midtime;
        int intx;
        int duration = (int) getMediaDuration();

        if (duration == 0) {
            return;
        }

        vTiers = transcription.getTiers();

        int vTiers_size = vTiers.size();

        for (int i = 0; i < vTiers_size; i++) {
            tier = (TierImpl) vTiers.elementAt(i);

            // aug 2005: if the tier is of type SymbolicAssociation it is 
            // guaranteed that the line for each annotation has been or 
            // will be drawn for the parent annotation
            if ((tier.getLinguisticType().getConstraints() != null) &&
                    (tier.getLinguisticType().getConstraints().getStereoType() == Constraint.SYMBOLIC_ASSOCIATION)) {
                continue;
            }

            annotations = ((TierImpl) tier).getAnnotations();

            int size = annotations.size();

            for (int j = 0; j < size; j++) {
                ann = (Annotation) annotations.elementAt(j);
                begintime = (int) ann.getBeginTimeBoundary();
                endtime = (int) ann.getEndTimeBoundary();

                midtime = (begintime + endtime) / 2;

                //intx = (int) ((imageWidth * midtime) / duration);
                intx = (int) (imageWidth * ((float) midtime / duration));
                big2d.drawLine(intx, 0, intx, imageHeight);
            }
        }

        displayImage = bi.getSubimage(0, 0, imageWidth, imageHeight);

        repaint();
    }

    /**
     * Handles the painting of the slider Consists of a vertical bar, a
     * crosshair and maybe a selection
     *
     * @param g DOCUMENT ME!
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

        if (getWidth() != imageWidth) {
            paintBuffer();
        }

        Graphics2D g2d = (Graphics2D) g;

        if (displayImage != null) {
            g2d.drawImage(displayImage, 0, 15, this);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param e DOCUMENT ME!
     */
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
        case ACMEditEvent.ADD_TIER:
        case ACMEditEvent.REMOVE_TIER:
        case ACMEditEvent.ADD_ANNOTATION_HERE:
        case ACMEditEvent.ADD_ANNOTATION_BEFORE:
        case ACMEditEvent.ADD_ANNOTATION_AFTER:
        case ACMEditEvent.REMOVE_ANNOTATION:
        case ACMEditEvent.CHANGE_ANNOTATION_TIME:
        case ACMEditEvent.CHANGE_ANNOTATIONS:
            paintBuffer();
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
    }

    /**
     * DOCUMENT ME!
     */
    public void updateActiveAnnotation() {
    }

    /**
     * DOCUMENT ME!
     */
    public void updateSelection() {
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void controllerUpdate(ControllerEvent event) {
    }
}


//end of AnnotationDensityViewer
