/*
 * File:     Controller.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.mediacontrol;


/**
 * Interface that gives the methods to be implemented by a Controller that is
 * connected to an ElanMediaPlayer
 */
public interface Controller {
    /**
     * DOCUMENT ME!
     */
    public void start();

    /**
     * DOCUMENT ME!
     */
    public void stop();

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setMediaTime(long time);

    public void setStopTime(long time);

    /**
     * DOCUMENT ME!
     *
     * @param rate DOCUMENT ME!
     */
    public void setRate(float rate);

    /**
     * DOCUMENT ME!
     *
     * @param listener DOCUMENT ME!
     */
    public void addControllerListener(ControllerListener listener);

    /**
     * DOCUMENT ME!
     *
     * @param listener DOCUMENT ME!
     */
    public void removeControllerListener(ControllerListener listener);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getNrOfConnectedListeners();

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void postEvent(ControllerEvent event);
}
