/*
 * File:     EventPoster.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.mediacontrol;


/**
 * Starts up a Thread with the task to deliver a ControllerEvent to a
 * ControllerListener.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 09-June-1998
 */
public class EventPoster implements Runnable {
    /** Holds value of property DOCUMENT ME! */
    ControllerListener listener;

    /** Holds value of property DOCUMENT ME! */
    ControllerEvent event;

    /**
     * Creates the Thread that tells the listener about the event.
     *
     * @param listener the ControllerListener that wants to receive
     *        ControllerEvents.
     * @param event the ControllerEvent that has to be posted to the listener.
     */
    public EventPoster(ControllerListener listener, ControllerEvent event) {
        this.listener = listener;
        this.event = event;
        new Thread(this).start();
    }

    /**
     * Tell the listener about the event.
     */
    public void run() {
        listener.controllerUpdate(event);
    }
}
