/*
 * File:     StopEvent.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.mediacontrol;


/**
 * Event that is sent as a paramater to controllerUpdate by the
 * TimeLineController and the PeriodicUpdateController. The new type StopEvent
 * is created to be able to distinguish it from other ControllerEvent in the
 * controllerUpdate methods
 */
public class StopEvent extends ControllerEvent {
    /**
     * Construct the StopEvent for a specific Controller
     *
     * @param controller DOCUMENT ME!
     */
    public StopEvent(Controller controller) {
        super(controller);
    }
}
