/*
 * File:     EnableTreeCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.util;

import mpi.eudico.tool.ToolID;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;


/**
 *
 */
public class EnableTreeCellRenderer extends DefaultTreeCellRenderer {
    /**
     * This is messaged from ToolTree whenever it needs to get the size of the
     * component or it wants to draw it. A JLabel is returned with text string
     * specified by value. value is either a DefaultMutableTreeNode or a
     * ToolTreeNode. In the latter case it is checked
     *
     * @param tree DOCUMENT ME!
     * @param value DOCUMENT ME!
     * @param isSelected DOCUMENT ME!
     * @param expanded DOCUMENT ME!
     * @param leaf DOCUMENT ME!
     * @param row DOCUMENT ME!
     * @param hasFocus DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Component getTreeCellRendererComponent(JTree tree, Object value,
        boolean isSelected, boolean expanded, boolean leaf, int row,
        boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded,
                leaf, row, hasFocus);

        setText(stringValue);

        if (value instanceof ToolTreeNode) {
            ToolID toolID = ((ToolTreeNode) value).getToolID();

            if (!toolID.isImplemented()) {
                setForeground(Color.lightGray);
                selected = false;
            } else if (toolID.isEnabled()) {
                setForeground(Color.black);
                selected = isSelected;
            } else {
                setForeground(Color.gray);
                selected = false;
            }
        } else {
            setForeground(Color.black);
            selected = isSelected;
        }

        return this;
    }
}
