/*
 * File:     LangCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.util;

import java.awt.Color;
import java.awt.Component;

import java.util.Locale;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;


/**
 * DOCUMENT ME!
 * $Id: LangCellRenderer.java,v 1.1.1.1 2004/03/25 16:23:17 wouthuij Exp $
 * @author $Author: wouthuij $
 * @version $Revision: 1.1.1.1 $
 */
public class LangCellRenderer extends JLabel implements ListCellRenderer {
    /**
     * Creates a new LangCellRenderer instance
     */
    public LangCellRenderer() {
        setOpaque(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @param list DOCUMENT ME!
     * @param value DOCUMENT ME!
     * @param index DOCUMENT ME!
     * @param isSelected DOCUMENT ME!
     * @param cellHasFocus DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus) {
        setText(((Locale) value).getDisplayName());
        setBackground(isSelected ? Color.lightGray : Color.white);
        setForeground(isSelected ? Color.white : Color.black);

        return this;
    }
}
