/*
 * File:     ToolTree.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.util;

import mpi.eudico.tool.ToolID;

import java.util.Iterator;
import java.util.TreeSet;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;


/**
 * The ToolTree is a JTree extended with a method to show a TreeSet. This
 * method is used by the EUDICO CorpusTree to show the current common subset
 * of Tools that is available for the chosen data set.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 30-Jun-1999
 */
public class ToolTree extends JTree {
    /** The root node of the ToolTree. */
    private DefaultMutableTreeNode root;

    /**
     * Creates a ToolTree with the specified root node.
     *
     * @param root the root node.
     */
    public ToolTree(DefaultMutableTreeNode root) {
        super(root);
        this.root = root;

        setCellRenderer(new EnableTreeCellRenderer());
    }

    /**
     * Shows a TreeSet from ToolIDs.
     *
     * @param tools
     */
    public void show(TreeSet tools) {
        ToolID toolID;
        DefaultMutableTreeNode category = null;
        root.removeAllChildren();

        if (tools != null) {
            Iterator iter = tools.iterator();

            while (iter.hasNext()) {
                toolID = (ToolID) iter.next();

                if ((category == null) ||
                        !toolID.getCategory().equals(category.toString())) {
                    category = new DefaultMutableTreeNode(toolID.getCategory());
                    root.add(category);
                }

                category.add(new ToolTreeNode(toolID));
            }
        }

        ((DefaultTreeModel) getModel()).nodeStructureChanged(root);
        expandRow(0);
    }
}
