/*
 * File:     ToolTreeNode.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.util;

import mpi.eudico.tool.ToolID;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * A ToolTreeNode contains a Tool identifier as its node Component.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 30-Jun-1999
 */
public class ToolTreeNode extends DefaultMutableTreeNode {
    /** The Tool identifier. */
    private ToolID toolID;

    /**
     * Creates a ToolTreeNode initialized with the specified Tool identifier.
     *
     * @param toolID the Tool identifier
     */
    public ToolTreeNode(ToolID toolID) {
        super(toolID);
        this.toolID = toolID;
    }

    /**
     * Returns the name by which the Tool is to be represented in the Tree.
     *
     * @return the ToolID name
     */
    public String toString() {
        return toolID.getName();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ToolID getToolID() {
        return toolID;
    }
}
