/*
 * File:     Transcription2QtSubtitle.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.util;

import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import mpi.eudico.util.TimeRelation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;


/**
 * Created on Jul 2, 2004
 *
 * @author Alexander Klassmann
 * @version Jul 2, 2004
 * @version Aug 2005 Identity removed
 */
public class Transcription2QtSubtitle {
    /** Holds value of property DOCUMENT ME! */
    final static private String NEWLINE = "\n";

    /**
     * Exports all annotations on specified tiers
     *
     * @param transcription
     * @param tierNames
     * @param exportFile
     *
     * @throws IOException
     */
    static public void exportTiers(Transcription transcription,
        String[] tierNames, File exportFile) throws IOException {
        exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    /**
     * Exports annotations that overlapp with specified time interval
     *
     * @param transcription
     * @param tierNames
     * @param exportFile
     * @param beginTime
     * @param endTime
     *
     * @throws IOException
     */
    static public void exportTiers(Transcription transcription,
        String[] tierNames, File exportFile, long beginTime, long endTime)
        throws IOException {
        if (exportFile == null) {
            return;
        }

        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out,
                    "UTF-8"));
        Annotation[] annotations = null;

        for (int j = 0; j < tierNames.length; j++) {
            TierImpl tier = (TierImpl) transcription.getTierWithId(tierNames[j]);

            annotations = (Annotation[]) tier.getAnnotations().toArray(new Annotation[0]);

            writer.write(
                "{QTtext}{timescale:100}{font:Arial}{size:12}{backColor:0,0,0}");
            writer.write(
                "{textColor:65535,65535,65535}{width:320}{justify:left}" +
                NEWLINE);

            for (int i = 0; i < annotations.length; i++) {
                if (annotations[i] != null) {
                    if (TimeRelation.overlaps(annotations[i], beginTime, endTime)) {
                        writer.write("[" +
                            TimeFormatter.toString(
                                annotations[i].getBeginTimeBoundary()) + "]" +
                            NEWLINE);
                        writer.write(annotations[i].getValue() + NEWLINE);
                        writer.write("[" +
                            TimeFormatter.toString(
                                annotations[i].getEndTimeBoundary()) + "]" +
                            NEWLINE);
                    }
                }
            }
        }

        writer.close();
    }
}
