/*
 * File:     Annotation.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.ACMEditableObject;
import mpi.eudico.server.corpora.util.ParentAnnotation;
import mpi.eudico.server.corpora.util.ParentAnnotationListener;

import java.util.Vector;


public interface Annotation extends AnnotationCore, Comparable, ACMEditableObject,
    ParentAnnotationListener, ParentAnnotation {
    public void setValue(String theValue);

    public void updateValue(String theValue);

    public Tier getTier();

    public void markDeleted(boolean deleted);

    public boolean isMarkedDeleted();

    public Vector getChildrenOnTier(Tier tier);

    /**
    * Checks if this Annotation has a parent Annotation.
    */
    public boolean hasParentAnnotation();

    /**
     * Returns this Annotation's parent Annotation.
     */
    public Annotation getParentAnnotation();

    /**
     * Returns the id of the annotation
     * @return
     */
    public String getId();

    /**
     * Sets the id of the annotation
     * @param s
     */
    public void setId(String s);
}
