/*
 * File:     Corpus.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.DataTreeNode;
import mpi.eudico.server.corpora.util.SharedDataObject;

import mpi.eudico.tool.ToolAdministrator;

import mpi.eudico.util.TreeViewable;


/**
 * A Corpus can either hold other Corpora or Sessions. It is implemented
 * by specific Corpora in the EUDICO database. The Corpus interface bundles the
 * roles of a Corpus as a browsable object (TreeViewable) and as a provider of
 * applicable Tools (ToolAdministrator)
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 10-Sep-1998
 * modified  2oct 2000; Daan Broeder
 * adapted for introduction of Sessions
 * @version Aug 2005 Identity and IdentityManager removed
 */
public interface Corpus extends TreeViewable, MetaDataContainer,
    ToolAdministrator, DataTreeNode, SharedDataObject {
    /**
     * Returns the name of the Corpus.
     *
     * @return    name of Corpus
     */
    public String getName();

    /**
     * Prints out what items and how many of them are contained in this
     * Corpus to the EUDICO server's console.
     */
    public void printStatistics();
}
