/*
 * File:     CorpusDatabase.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.DataTreeNode;

import mpi.eudico.tool.ToolAdministrator;

import mpi.eudico.util.TreeViewable;

import java.util.Vector;


/**
 * CorpusDatabase is the (Remote) interface for CorpusDatabaseImpl, a
 * class with one server based object that forms the entry point for
 * all Corpora in the EUDICO system. CorpusDatabase is browsable
 * (TreeViewable), administrates applicable Tools (ToolAdministrator),
 * and handles user identification (IdentityManager).
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 25-Mar-1999
 * @version Aug 2005 Identity and IdentityManager removed
 */

/* modified 5 oct 2000 Daan Broeder
* CorpusDatabase extends MetaDataContainer because it can have meta-data
*/
public interface CorpusDatabase extends TreeViewable, MetaDataContainer,
    ToolAdministrator, DataTreeNode {
    /**
     * gets the corpora in this Corpus database
     */
    Vector getCorpora();

    /**
     * Prints statistics of component Corpora to the EUDICO server's console.
     * <code>printStatistics</code> is recursively called on the Corpus hierarchy.
     */
    public void printStatistics();

    /** Forces the EUDICO server VM to do a Garbage Collect. Is made available
     * for testing purposes only.
     */
    public void collectGarbage();

    /**
     * Returns the single instance of the ToolDatabase.
     */
    public ToolDatabase getToolDatabase();
}
