/*
 * File:     LeafCorpus.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import java.util.Vector;


/**
 * A LeafCorpus is a Corpus that can only hold Sessions, not other
 * Corpora.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 29-Jun-1998
 * @version Aug 2005 Identity removed
 * modified  2oct 2000; Daan Broeder
 * adapted for introduction of Sessions
 */
public interface LeafCorpus extends Corpus {
    /**
     * Returns the list of Sessions that are accessible
     */
    public Vector getSessions();

    /**
     * Removes a Session from the LeafCorpus.
     *
     * @param theSession    the session to be removed
     */
    public void removeSession(Session theSession);
}
