/*
 * File:     MetaData.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.util.TreeViewable;

import java.util.Vector;


/**
 * Interface MetaData
 * models meta-data information & structure
 *
 * A MetaData can be structured as a tree of other MetaDataResources
 * so it implements MetaDataContainer
 * A MetaData object can refer to LanguageResources (will be modified in near future)
 * @version Aug 2005 Identity removed
 */
public interface MetaData extends MetaDataContainer, TreeViewable {
    // methods to access LanguageResources
    public Vector getLanguageResources();

    public boolean hasLanguageResources();

    // methods that provide access to meta data items themselves
    public String getTag();

    public String getDescription();

    public String getInfo();
}
