/*
 * File:     Session.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.DataTreeNode;
import mpi.eudico.server.corpora.util.SharedDataObject;

import mpi.eudico.tool.ToolAdministrator;

import mpi.eudico.util.TreeViewable;

import java.util.Vector;


/**
 * Session is the concept of bundeling all resorces that pertainn to a
 * linguistic action. A Session bundles transcriptions, media files,
 * meta-data, photographs. Sessions are contained in LeafCorpora.  A Session
 * is browsable  (TreeViewable), is accessible to multiple Identities
 * (DataLocatorList), can be manipulated or displayed by Tools
 * (ToolAdministrator) and is part of the Corpus data hierarchy
 * (DataTreeNode).
 *
 * @author Daan Broeder
 * @version 27 Sept. 2000
 * @version Aug 2005 Identity removed
 */
public interface Session extends TreeViewable, MetaDataContainer,
    SharedDataObject, ToolAdministrator, DataTreeNode {
    /**
     * Gives the Session name.
     *
     * @return the name
     */
    public String getName();

    /**
     * Returns the owner of the Session object.
     *
     * @return the owner
     */
    public String getOwner();

    /**
     * Returns the if there are LanguageResources that are accessible.
     *
     * @return boolean
     */
    public boolean hasLanguageResources();

    /**
     * Returns the list of LanguageResources that are accessible.
     *
     * @return the list of LanguageResources
     */
    public Vector getLanguageResources();

    /**
     * Prints some statistics of the Transcription. This method is used for
     * testing and debugging purposes. Since Transcription is implemented as
     * remote object the statistics are printed on the server's console.
     */
    public void printStatistics();
}
