/*
 * File:     Tag.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.ACMEditableObject;

import java.util.Vector;


/**
 * A Tag is EUDICO's basic unit of transcription. It has an (optional) begin
 * time and end time, as well as several textual fields. The order and types
 * of these fields are determined by the CodeGroup that is associated with the
 * Tag's Tier.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 21-Apr-1999
 */
public interface Tag extends Comparable, ACMEditableObject {
    /**
     * Gives the Tag's begin time in milliseconds.
     *
     * @return begin time in milliseconds
     */
    public long getBeginTime();

    /**
     * Gives the Tag's end time in milliseconds.
     *
     * @return end time in milliseconds
     */
    public long getEndTime();

    /**
     * Returns a list of textual values for the Tag's time interval, in the
     * order specified by a CodeGroup.
     *
     * @return a list of textual values
     */
    public Vector getValues();

    /**
     * Returns the Tier of which this Tag is a component.
     *
     * @return the Tag's Tier
     */
    public Tier getTier();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getIndex();

    /**
     * Adjusts index of Tag in the Transcription. Should only be called by an
     * entity that is responsible for mananging these indices (usually the
     * Transcription's MetaTime.
     */
    public void setIndex(int theIndex);

    /**
     * Returns true if the Tag is aligned with the time axis of Transcription's
     * MediaObject. An unaligned Tag has zero begin and end times.
     *
     * @return DOCUMENT ME!
     */
    public boolean isTimeAligned();

    /**
     * Returns true if this Tag comes after theTag. Implementation specific Tag
     * ordering is handled here (used when adding to MetaTime).
     * Comparable.compareTo orders Tags on index.
     *
     * @return DOCUMENT ME!
     */
    public boolean isAfter(Tag theTag);
}
