/*
 * File:     TierSharedInfo.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.util.SharedDataObject;


/**
 * TierSharedInfo consists of attributes that can be shared by different Tiers
 * in different Transcriptions. For example, a TierSharedInfo attribute is the
 * Tier's CodeGroup, describing legal values for all fields in the Tier's
 * Tags. The purpose of TierSharedInfo is to facilitate reuse of Tier setup
 * information for a group of similarly coded Transcriptions.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 11-Sep-1998
 */
public interface TierSharedInfo extends SharedDataObject {
    /**
     * Returns the name of the Tier. Tier names can be shared among similarly
     * coded Transcriptions.
     *
     * @return the Tier's name
     */
    public String getTierName();

    /**
     * DOCUMENT ME!
     *
     * @param theName DOCUMENT ME!
     *
     */
    public void setTierName(String theName);

    /**
     * Gives the Participant with whom the Tier is associated. Several
     * participants can be involved in the recorded event that is represented
     * in the Tier's Transcription.
     *
     * @return the Tier's participant
     */
    public String getParticipant();

    /**
     * Return the Tier's CodeGroup. A CodeGroup describes the 'grammar' of the
     * Tier's Tags.
     *
     * @return the Tier's CodeGroup
     */
    public CodeGroup getCodeGroup();
}
