/*
 * File:     ToolDatabase.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.tool.Tool;
import mpi.eudico.tool.ToolAdministrator;
import mpi.eudico.tool.ToolID;

import java.util.Vector;


/**
 * DOCUMENT ME!
 * $Id: ToolDatabase.java,v 1.3 2005/08/17 13:28:27 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.3 $
 */
public interface ToolDatabase {
    /**
     * Return a list of ToolIDs that apply to the specified toolAdmin
     *
     * @param toolAdmin
     *
     * @return DOCUMENT ME!
     */
    public Vector getAvailableTools(ToolAdministrator toolAdmin);

    /**
     * Creates and returns a Tool as specified by theToolId. This Tool is
     * associated with the data elements specified by dataTreeNodes. The
     * return value can be either a remote reference to a server based Tool or
     * a reference to a local Tool. When called remotely the latter implies
     * sending a Serialised copy to the client.
     *
     * @return DOCUMENT ME!
     */
    public Tool createTool(ToolID theToolId, Vector dataTreeNodes);
}
