/*
 * File:     TranscriptionStore.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clom;

import java.util.Vector;


/**
 * First attempt to abstract persistent storage. If this works for DOBES
 * minimal and DOBES-ATLAS implementations, generalization to ACM will be
 * done.
 * @version Aug 2005 Identity removed
 */
public interface TranscriptionStore {
    public static final int EAF = 0;
    public static final int CHAT = 1;
    public static final int SHOEBOX = 2;
    public static final int TRANSCRIBER = 3;

    /**
     * DOCUMENT ME!
     *
     * @param theTranscription DOCUMENT ME!
     * @param tierOrder DOCUMENT ME!
     *
     */
    public void storeTranscription(Transcription theTranscription,
        EncoderInfo encoderInfo, Vector tierOrder, int format);

    public void storeTranscription(Transcription theTranscription,
        EncoderInfo encoderInfo, Vector tierOrder, String pathName, int format);

    /**
     * DOCUMENT ME!
     *
     * @param theTranscription DOCUMENT ME!
     */
    public void loadTranscription(Transcription theTranscription);
}
