/*
 * File:     DefaultLocatorManager.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clomdefault;

import mpi.eudico.server.corpora.location.DataLocator;
import mpi.eudico.server.corpora.location.DirectoryTree;
import mpi.eudico.server.corpora.location.LocatorManager;


/**
 * Extends abstract class LocatorManager Encapsulates a DirectoryTree and could
 * restrict access to it (does not).
 * @version Aug 2005 Identity removed
 */
public class DefaultLocatorManager extends LocatorManager {
    private DefaultDataLocator locator;

    /**
     * Uses a DefaultDataLocator for the DirectoryTree
     *
     * @param theTree ???
     */
    public DefaultLocatorManager(DirectoryTree theTree) {
        locator = new DefaultDataLocator(theTree);
    }

    /**
     * Implementing abstract method from LocatorManager.
     *
     * @return DOCUMENT ME!
     */
    public DataLocator getDataLocator() {
        return this.locator;
    }
}
