/*
 * File:     CompositeCorpusImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.CompositeCorpus;
import mpi.eudico.server.corpora.clom.Corpus;

import mpi.eudico.server.corpora.location.DirectoryTree;
import mpi.eudico.server.corpora.location.LocatorManager;

import mpi.eudico.server.corpora.util.DataTreeNode;

import java.io.File;

import java.util.Iterator;
import java.util.Vector;


/**
 * CompositeCorpus ....
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 10-Jun-1999
 * @version Aug 2005 Identity removed
 */
public abstract class CompositeCorpusImpl implements CompositeCorpus {
    /** The name of the Corpus */
    private String name;

    /** A list of Corpora that are part of this CompositeCorpus */
    protected Vector subCorpora;

    /**
     * The parent of this Corpus in the Corpus data hierarchy, this is either
     * another CompositeCorpus or the CorpusDatabase.
     */
    private DataTreeNode parent;

    /**
     *
     */
    /** Holds value of property DOCUMENT ME! */
    protected LocatorManager locatorManager;

    /**
     *
     */
    /** Holds value of property DOCUMENT ME! */
    protected File relativePath;

    /**
     * Constructor for Composites
     *
     * @param theName the name of this Corpus
     * @param theParent DOCUMENT ME!
     * @param theLocatorMgr DOCUMENT ME!
     * @param theRelativePath DOCUMENT ME!
     *
     */
    public CompositeCorpusImpl(String theName, DataTreeNode theParent,
        LocatorManager theLocatorMgr, File theRelativePath) {
        name = theName;

        parent = theParent;
        relativePath = new File(theRelativePath, theName);
        locatorManager = theLocatorMgr;

        subCorpora = new Vector();
    }

    /**
     * Constructor for top level Composites
     *
     * @param theName the name of this Corpus
     * @param theParent DOCUMENT ME!
     * @param theTree DOCUMENT ME!
     *
     */
    public CompositeCorpusImpl(String theName, DataTreeNode theParent,
        DirectoryTree theTree) {
        name = theName;
        parent = theParent;
        subCorpora = new Vector();

        relativePath = new File("");
    }

    /**
     * Returns the name of the Corpus.
     *
     * @return name of Corpus
     *
     */
    public String getName() {
        return name;
    }

    /**
     * Gives the name of this Corpus.
     *
     * @return the name of the Corpus
     *
     */
    public String getNodeName() {
        return getName();
    }

    /**
     * A CompositeCorpus is never a leaf node in the tree of Corpus data,
     * therefore 'false' is always returned.
     *
     * @return return value is always 'false'
     *
     */
    public boolean isTreeViewableLeaf() {
        return false;
    }

    /**
     * Gives all children of this node in the tree of corpora.
     *
     *
     * @return a list of child objects, in this case sub-corpora
     *
     */
    public Vector getChildren() {
        return getCorpora();
    }

    /**
     * add a subcorpus to this corpus
     *
     * @param c DOCUMENT ME!
     */

    //added DGB
    public void addCorpus(Corpus c) {
        subCorpora.add(c);
    }

    /**
     * getMetaData()
     *
     * @return DOCUMENT ME!
     */
    public Vector getMetaData() {
        return null;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public boolean hasMetaData() {
        return false;
    }

    /**
     * Give all Tools that are applicable to a data object in the Corpus
     * hierarchy.
     *
     * @return the set of available tools
     *
     */
    public Vector getAvailableTools() {
        return ToolDatabaseImpl.Instance().getAvailableTools(this);
    }

    /**
     * Prints statistics of component Corpora to the EUDICO server's console.
     * <code>printStatistics</code> is recursively called on the Corpus
     * hierarchy.
     *
     */
    public void printStatistics() {
        System.out.println("Corpus name: " + name);
        System.out.println("-->contains: " + subCorpora.size() + " subcorpora");

        Iterator iter = subCorpora.iterator();

        while (iter.hasNext()) {
            ((Corpus) iter.next()).printStatistics();
        }
    }

    // DataTreeNode interface method

    /**
     * Returns the parent object in the hierarchy of Corpus data objects.
     *
     * @return the parent DataTreeNode
     *
     */
    public DataTreeNode getParent() {
        return parent;
    }

    /**
     * Removes a child in the Corpus data hierarchy by deleting the reference
     * to the child. The garbage collector will then do the actual deletion.
     * Children for CompositeCorpora are Corpora.
     *
     * @param theChild the child to be deleted
     *
     */
    public void removeChild(DataTreeNode theChild) {
        subCorpora.remove(theChild);
    }

    // SharedDataObject interface method(s), via Corpus interface
}
