/*
 * File:     ParserFactory.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Jun 4, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clomimpl.chat.CHATParser;

//import mpi.eudico.server.corpora.clomimpl.cgn2acm.CGN2ACMParser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF21Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF22Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF23Parser;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxParser;
import mpi.eudico.server.corpora.clomimpl.transcriber.Transcriber14Parser;


/**
 * @author hennie
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ParserFactory {
    public static int EAF21 = 0;
    public static int CHAT = 1;
    public static int SHOEBOX = 2;
    public static int TRANSCRIBER = 3;
    public static int CGN = 4;
    public static int WAC = 5;
    public static int EAF22 = 6;
    public static int EAF23 = 7;

    public static Parser getParser(int parserCode) {
        if (parserCode == EAF21) {
            return new EAF21Parser();
        } else if (parserCode == EAF22) {
            return new EAF22Parser();
        } else if (parserCode == EAF23) {
            return new EAF23Parser();
        } else if (parserCode == CHAT) {
            return new CHATParser();
        } else if (parserCode == SHOEBOX) {
            return new ShoeboxParser();
        } else if (parserCode == TRANSCRIBER) {
            return new Transcriber14Parser();
        } else if (parserCode == CGN) {
            //done this way to avoid explicit dependencies!
            Parser parser = null;

            try {
                parser = (Parser) Class.forName(
                        "mpi.eudico.server.corpora.clomimpl.cgn2acm.CGN2ACMParser")
                                       .newInstance();
            } catch (Exception e) {
                e.printStackTrace();
            }

            return parser;
        } else {
            return null;
        }
    }
}
