/*
 * File:     ToolDatabaseImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.ToolDatabase;

import mpi.eudico.tool.RemoteTool;
import mpi.eudico.tool.Tool;
import mpi.eudico.tool.ToolAdministrator;
import mpi.eudico.tool.ToolCondition;
import mpi.eudico.tool.ToolID;
import mpi.eudico.tool.ToolProxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;


/**
 * Under construction, not yet documented.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 2-Jul-1999
 * @version Aug 2005 Identity removed
 */
public class ToolDatabaseImpl implements ToolDatabase {
    /** Reference to the only incarnation of the ToolDatabase. */
    private static ToolDatabase toolDB;

    /** xxx */
    private Hashtable table;

    /**
     * Constructor
     *
     * @param fileName the name of the ToolDatabase file. Not Yet Used!
     */
    private ToolDatabaseImpl(String fileName) {
        table = new Hashtable();

        // general tool ids
        ToolID mediaViewers = new ToolID("Viewers",
                "Media Synchronized Viewers",
                "mpi.eudico.client.tool.viewer.DisplayState", true, false, true);
        mediaViewers.addCondition(new ToolCondition(
                ToolCondition.MEDIA_AVAILABLE));

        ToolID export2XML = new ToolID("Export Modules", "Export to XML", null,
                false, true, false);
        ToolID generalSearch = new ToolID("Search", "General search", null,
                false, true, false);

        ToolID annotationTool = new ToolID("Annotations",
                "Media Alignment Tool",
                "mpi.eudico.client.tool.viewer.MediaAlignmentTool", true,
                false, true);
        annotationTool.addCondition(new ToolCondition(
                ToolCondition.MEDIA_AVAILABLE));

        ToolID corexViewer = new ToolID("Viewers", "Simple COREX Viewer",
                "mpi.eudico.client.tool.viewer.CorexViewer", true, false, true);
        ToolID corexSearch = new ToolID("Search", "Corex Search",
                "mpi.eudico.search.CGNSearchApp", true, false, true);

        Vector GesCor = new Vector();
        GesCor.add(new ToolID("Search", "Time related queries", null, false,
                true, false));
        GesCor.add(new ToolID("Search", "Simple SQL statements", null, false,
                true, false));
        GesCor.add(generalSearch);
        table.put("mpi.eudico.server.corpora.clomimpl.gesture.GestureCorpus",
            GesCor);

        Vector GesTran = new Vector();
        GesTran.add(mediaViewers);
        GesTran.add(export2XML);
        GesTran.add(annotationTool);
        GesTran.add(new ToolID("Viewers", "Simple MultiTier Viewer",
                "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true,
                false, true));
        GesTran.add(generalSearch);
        GesTran.add(new ToolID("Search", "Simple SQL statements", null, false,
                true, false));
        table.put("mpi.eudico.server.corpora.clomimpl.gesture.GestureTranscription",
            GesTran);

        Vector CHATCor = new Vector();
        CHATCor.add(new ToolID("CHILDES related tools", "kwic concordance",
                null, false, true, false));
        CHATCor.add(generalSearch);
        table.put("mpi.eudico.server.corpora.clomimpl.chat.CHATCompositeCorpus",
            CHATCor);
        table.put("mpi.eudico.server.corpora.clomimpl.chat.CHATCorpus", CHATCor);

        //Session nodes have tools too
        Vector CHATSes = new Vector();
        CHATSes.add(mediaViewers);
        table.put("mpi.eudico.server.corpora.clomimpl.chat.CHATSession", CHATSes);

        Vector CHATTran = new Vector();
        CHATTran.add(new ToolID("Viewers", "Simple MultiTier Viewer",
                "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true,
                false, true));
        CHATTran.add(mediaViewers);
        CHATTran.add(export2XML);
        CHATTran.add(annotationTool);
        CHATTran.add(new ToolID("CHILDES related tools", "kwic concordance",
                null, false, true, false));
        CHATTran.add(generalSearch);
        table.put("mpi.eudico.server.corpora.clomimpl.chat.CHATTranscription",
            CHATTran);

        ///Markus Editing START
        Vector ShoeboxCor = new Vector();
        table.put("mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxCompositeCorpus",
            ShoeboxCor);
        table.put("mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxCorpus",
            ShoeboxCor);

        Vector ShoeboxTrans = new Vector();
        ShoeboxTrans.add(new ToolID("Viewers", "Simple MultiTier Viewer",
                "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true,
                false, true));

        // I do *not* want all mediaviewer applied to shoebox
        //ShoeboxTrans.add(mediaViewers);
        //GUB I forgot to c&p change .chat. into .shoebox.
        table.put("mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTranscription",
            ShoeboxTrans);

        /// Markus Editing STOP
        Vector cgnTran = new Vector();
        cgnTran.add(corexViewer);
        table.put("mpi.eudico.server.corpora.clomimpl.cgn.CGNTranscription",
            cgnTran);

        Vector cgnSess = new Vector();
        cgnSess.add(corexViewer);
        table.put("mpi.eudico.server.corpora.clomimpl.cgn.CGNSession", cgnSess);

        Vector cgnCorp = new Vector();
        cgnCorp.add(corexSearch);
        table.put("mpi.eudico.server.corpora.clomimpl.cgn.CGNCompositeCorpus",
            cgnCorp);

        Vector dobesTran = new Vector();
        dobesTran.add(annotationTool);
        dobesTran.add(mediaViewers);
        dobesTran.add(new ToolID("Viewers", "Simple MultiTier Viewer",
                "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true,
                false, true));
        table.put("mpi.eudico.server.corpora.clomimpl.dobes.DobesTranscription",
            dobesTran);

        Vector dobesSess = new Vector();
        dobesSess.add(annotationTool);
        dobesSess.add(mediaViewers);
        dobesSess.add(new ToolID("Viewers", "Simple MultiTier Viewer",
                "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true,
                false, true));
        table.put("mpi.eudico.server.corpora.clomimpl.dobes.DobesSession",
            dobesSess);

        /*    Vector GATECor = new Vector();
           GATECor.add(generalSearch);
           table.put("mpi.eudico.server.corpora.clomimpl.gate.GATECompositeCorpus", GATECor);
           table.put("mpi.eudico.server.corpora.clomimpl.gate.GATECorpus", GATECor);
           Vector GATETran = new Vector();
           GATETran.add(mediaViewers);
           GATETran.add(new ToolID("Viewers", "Simple MultiTier Viewer", "mpi.eudico.client.tool.viewer.SimpleMultiTierViewer", true, false, true));
           GATETran.add(new ToolID("Viewers", "GATE TagPanel Container", "mpi.eudico.client.tool.gateviewer.GATEViewer", true, false, true));
           GATETran.add(new ToolID("Viewers", "GATE Synchronized Viewers", "mpi.eudico.client.tool.gateviewer.GATEDisplayState", true, false, true));
           GATETran.add(export2XML);
           GATETran.add(generalSearch);
           GATETran.add(new ToolID("GATE HLT Tools", "PoS Tagger", null, false, true, false));
           table.put("mpi.eudico.server.corpora.clomimpl.gate.GATETranscription", GATETran);    */
    }

    /**
     * Plays the role of constructor in this Singleton.
     *
     * @return DOCUMENT ME!
     */
    public static ToolDatabase Instance() {
        if (toolDB == null) {
            toolDB = new ToolDatabaseImpl("tooldatabase");
        }

        return toolDB;
    }

    /**
     * xxx
     *
     * @param toolAdmin
     *
     * @return DOCUMENT ME!
     */
    public Vector getAvailableTools(ToolAdministrator toolAdmin) {
        System.out.println("--> " + toolAdmin.getClass().getName());

        Vector tools = (Vector) table.get(toolAdmin.getClass().getName());

        Vector result = new Vector();

        if (tools != null) {
            // check conditions on all tools
            //	result.addAll(tools);
            Iterator toolIter = tools.iterator();

            while (toolIter.hasNext()) {
                ToolID toolID = (ToolID) toolIter.next();
                Vector conditions = toolID.getConditions();

                toolID.setEnabled(true);

                boolean conditionsMet = true;

                // check all conditions, when one is not met, remove toolID from
                // result and go on with next toolID
                Iterator conditionIter = conditions.iterator();

                while (conditionIter.hasNext()) {
                    ToolCondition cond = (ToolCondition) conditionIter.next();

                    if (!toolAdmin.checkToolCondition(cond)) {
                        if (cond.whichCondition() == ToolCondition.MEDIA_AVAILABLE) {
                            // no media available
                            toolID.setEnabled(false);
                        } else {
                            // result.remove(toolID);
                            conditionsMet = false;

                            break;
                        }
                    }
                }

                if (conditionsMet) {
                    result.add(toolID);
                }
            }

            return result;
        } else {
            return new Vector();
        }
    }

    public Tool createTool(ToolID theToolId, Vector dataTreeNodes) {
        Tool tool = null;

        System.out.println("ToolDBImpl:createTool() ");

        String toolClassName = theToolId.getClassName();

        if (!toolClassName.equals("")) {
            try {
                // Get the Class for the selected Tool.
                Class toolClass = Class.forName(toolClassName);

                // We are going to ask for a Tool Constructor with the
                // parameter types of Object and Identity.
                Class[] constructorParameterClasses = new Class[1];
                constructorParameterClasses[0] = Class.forName(
                        "java.lang.Object");

                // Get the apropriate Constructor for the Tool
                Constructor constructor = toolClass.getConstructor(constructorParameterClasses);

                // The parameters for the Tool are the dataObject.
                Object[] parameters = new Object[1];
                parameters[0] = dataTreeNodes.firstElement();

                // Create a new instance of the Tool
                Object theTool = constructor.newInstance(parameters);
                System.out.println("ToolDBImpl:createTool() created: " +
                    theTool.getClass().getName());

                if (theToolId.hasServerVersion()) {
                    tool = new ToolProxy((RemoteTool) theTool);
                } else {
                    tool = (Tool) theTool;
                }
            } catch (InvocationTargetException ite) {
                System.out.println(ite.getTargetException());
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        return tool;
    }
}
