/*
 * File:     TierRecord.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clomimpl.dobes;


/**
 * A record storing the tier's attributes e.g. as parsed from the eaf.
 *
 * @author Han Sloetjes
 */
public class TierRecord {
    /** the name of the tier */
    private String name;

    /** the default locale */
    private String defaultLocale;

    /** the linguistic type name */
    private String linguisticType;

    /** the participant */
    private String participant;

    /** the parent tier name */
    private String parentTier;

    /**
     * Returns the locale name
     *
     * @return the locale name
     */
    public String getDefaultLocale() {
        return defaultLocale;
    }

    /**
     * Returns the linguistic type's name
     *
     * @return the linguistic type
     */
    public String getLinguisticType() {
        return linguisticType;
    }

    /**
     * Returns the tier's name
     *
     * @return the tier's name
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the tier's parent tier's name
     *
     * @return the parent's name
     */
    public String getParentTier() {
        return parentTier;
    }

    /**
     * Returns the participant
     *
     * @return the participant
     */
    public String getParticipant() {
        return participant;
    }

    /**
     * Sets the locale
     *
     * @param locale the locale
     */
    public void setDefaultLocale(String locale) {
        defaultLocale = locale;
    }

    /**
     * Sets the linguistic type
     *
     * @param type the linguistic type name
     */
    public void setLinguisticType(String type) {
        linguisticType = type;
    }

    /**
     * Sets the name
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Sets the parent's name
     *
     * @param name parent's name
     */
    public void setParentTier(String name) {
        parentTier = name;
    }

    /**
     * Sets the participant
     *
     * @param part the participant
     */
    public void setParticipant(String part) {
        participant = part;
    }
}
