/*
 * File:     AnnotationSizeContainer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;

import mpi.eudico.server.corpora.clom.Annotation;

import java.awt.Rectangle;


/**
 * DOCUMENT ME!
 * $Id: AnnotationSizeContainer.java,v 1.1 2005/08/11 15:28:21 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.1 $
 */
public class AnnotationSizeContainer implements Comparable {
    /** Holds value of property DOCUMENT ME! */
    public static int PIXELS = 1;

    /** Holds value of property DOCUMENT ME! */
    public static int SPACES = 2;
    private int _size;
    private Annotation _ann;
    private int _type = 0;
    private long _stime = 0;

    /** Holds value of property DOCUMENT ME! */
    public Long _lstime = null;
    private long _etime = 0;
    private Rectangle _rect = null;

    /**
     * Creates a new AnnotationSizeContainer instance
     *
     * @param ann DOCUMENT ME!
     * @param size DOCUMENT ME!
     * @param st DOCUMENT ME!
     * @param et DOCUMENT ME!
     * @param type DOCUMENT ME!
     */
    public AnnotationSizeContainer(Annotation ann, Integer size, long st,
        long et, int type) {
        _ann = ann;
        _size = size.intValue();
        _type = type;
        _stime = st;
        _etime = et;
        _lstime = new Long(_stime);
    }

    /**
     * Creates a new AnnotationSizeContainer instance
     *
     * @param ann DOCUMENT ME!
     * @param size DOCUMENT ME!
     * @param type DOCUMENT ME!
     */
    public AnnotationSizeContainer(Annotation ann, Integer size, int type) {
        _ann = ann;
        _size = size.intValue();
        _type = type;

        if (ann != null) {
            _lstime = new Long(ann.getBeginTimeBoundary());
        }
    }

    /**
     * Creates a new AnnotationSizeContainer instance
     *
     * @param ann DOCUMENT ME!
     * @param size DOCUMENT ME!
     * @param type DOCUMENT ME!
     */
    public AnnotationSizeContainer(Annotation ann, int size, int type) {
        _ann = ann;
        _size = size;
        _type = type;

        if (ann != null) {
            _lstime = new Long(ann.getBeginTimeBoundary());
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param rect DOCUMENT ME!
     */
    public void setRect(Rectangle rect) {
        _rect = rect;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Annotation getAnnotation() {
        return _ann;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return _size;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getType() {
        return _type;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getStartTime() {
        return _stime;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getEndTime() {
        return _etime;
    }

    // compoare to interface for locatet
    public int compareTo(Object o) {
        if (_lstime == null) {
            System.out.println("NULL STIME");

            return -1;
        }

        Long l = null;
        Long l1 = null;

        if (_ann != null) {
            l1 = new Long(_ann.getBeginTimeBoundary());
        }

        if (o instanceof Long) {
            l = (Long) o;
        } else {
            l = new Long(((AnnotationSizeContainer) o).getAnnotation()
                          .getBeginTimeBoundary());
        }

        System.out.println(l1 + " " + l1);

        return l1.compareTo(l);
    }
}
