/*
 * File:     MarkerRecord.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Jul 1, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;


/**
 * @author hennie
 */
public class MarkerRecord {
    // character encoding
    public static final int UTF8 = 0;
    public static final int ISOLATIN = 1;
    public static final int SILIPA = 2;
    public static final String ISOLATINSTRING = "ISO-Latin-1";
    public static final String UNICODESTRING = "Unicode (UTF-8)";
    public static final String SILIPASTRING = "SIL IPA";
    public static final String[] charsetStrings = {
        ISOLATINSTRING, UNICODESTRING, SILIPASTRING
    };
    private String marker;
    private String parentMarker;
    private String stereoType;
    private String charsetString;
    private boolean participantMarker = false;
    private boolean exclude = false;

    /**
     * @return
     */
    public String getCharsetString() {
        return charsetString;
    }

    public int getCharset() {
        int charset = -1;

        if (charsetString.equals(ISOLATINSTRING)) {
            charset = ISOLATIN;
        } else if (charsetString.equals(UNICODESTRING)) {
            charset = UTF8;
        } else if (charsetString.equals(SILIPASTRING)) {
            charset = SILIPA;
        }

        return charset;
    }

    /**
     * @return
     */
    public String getMarker() {
        return marker;
    }

    /**
     * @return
     */
    public String getParentMarker() {
        return parentMarker;
    }

    /**
     * @return
     */
    public String getStereoType() {
        return stereoType;
    }

    public boolean getParticipantMarker() {
        return participantMarker;
    }

    public boolean isExcluded() {
        return exclude;
    }

    /**
     * @param string
     */
    public void setCharset(String charset) {
        this.charsetString = charset;
    }

    /**
     * @param string
     */
    public void setMarker(String string) {
        marker = string;
    }

    /**
     * @param string
     */
    public void setParentMarker(String string) {
        parentMarker = string;
    }

    /**
     * @param string
     */
    public void setStereoType(String string) {
        stereoType = string;
    }

    public void setParticipantMarker(boolean bool) {
        participantMarker = bool;
    }

    public void setExcluded(boolean bool) {
        exclude = bool;
    }

    public String toString() {
        return "marker:      " + marker + "\n" + "parent:      " +
        parentMarker + "\n" + "stereotype:  " + stereoType + "\n" +
        "charset:     " + charsetString + "\n" + "exclude:     " + exclude +
        "\n" + "participant: " + participantMarker + "\n";
    }
}
