/*
 * File:     TimeCodedTranscription.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Dec 17, 2004
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import java.util.Vector;


/**
 * This interface is a sub-interface of Transcription. It contains only the
 * methods that are used in the interlinearizer package. Interlinearizer's
 * classes will use TimeCodedTranscription to retrieve their information about
 * the annotation document. The intended implementation will delegate method
 * calls to a wrapped Transcription, but allows to override methods when
 * necessary, for example to add time code tiers without modifying the wrapped
 * document.
 *
 * @author hennie
 * @version Aug 2005 Identity removed
 */
public interface TimeCodedTranscription {
    /** Holds value of property DOCUMENT ME! */
    public static final String TC_LING_TYPE = "12nov2004_temp$LING$type"; // unlikely type name

    /** Holds value of property DOCUMENT ME! */
    public static final String TC_TIER_PREFIX = "TC-";

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Transcription getTranscription();

    // for delegation and override
    public Vector getTiers();

    /**
     * DOCUMENT ME!
     *
     * @param theAnnot DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getChildAnnotationsOf(Annotation theAnnot);

    /**
     * DOCUMENT ME!
     *
     * @param theTier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public TierImpl getParentTier(Tier theTier);

    /**
     * DOCUMENT ME!
     *
     * @param forTier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public TierImpl getRootTier(Tier forTier);

    /**
     * DOCUMENT ME!
     *
     * @param tier1 DOCUMENT ME!
     * @param tier2 DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isAncestorOf(Tier tier1, Tier tier2);

    /**
     * DOCUMENT ME!
     *
     * @param tier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getTierTree(TierImpl tier);

    // to manage time code tiers		
    public void prepareTimeCodeRendering(int timeCodeStyle);

    /**
     * DOCUMENT ME!
     */
    public void cleanupTimeCodeTiers();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getTimeCodeTiers();
}
